## **Key Concepts in Retrospective Security**

### **The Challenge of Certainty in Security**

- Security practitioners cannot guarantee 100% certainty that something is safe; decisions are based on current understanding.
- A file or traffic initially marked as "safe" might later be deemed unsafe.
- Questions arise when unsafe traffic or files have already entered the network:
    - Where has the traffic or file been?
    - Which endpoints or systems have been affected?
    - Has the malware spread internally or externally?

---

### **Steps After Discovering a Breach**

1. **Identify the Breach Source:**
    - Example: If the source is an IP address (e.g., 198.51.100.1), block it at the firewall.
2. **Contain and Remediate the Breach:**
    - Determine where the malware has been in the network.
    - Identify endpoints, files, or systems affected.
    - Check if it has spread to mobile devices, customers, or partners.
3. **Answer Critical Questions:**
    - "Which endpoints downloaded the file?"
    - "Where else has the malware gone?"
    - "What actions need to be taken, and who needs to be informed?"

---

### **What is Retrospective Security?**

- **Definition:**
    - Retrospective security allows you to change a prior decision about "safe" traffic or files and track where that traffic or file has been.
- **Capabilities:**
    - Keeps track of seemingly benign traffic and its journey within the network.
    - Enables rapid identification and blocking of previously approved traffic/files that are later deemed unsafe.
    - Enhances the ability to locate and remediate malicious activity without waiting for new traffic or endpoint scans.

---

### **Typical Security vs. Retrospective Security**

- **Typical Security:**
    - Perimeter devices (firewall, IPS, proxy) allow traffic into the network but don’t track where the traffic goes afterward.
    - Cannot retroactively address previously allowed malicious traffic.
- **Retrospective Security:**
    - Tracks where allowed traffic has been inside the network.
    - Provides insights into the historical path of malicious traffic or files for immediate remediation.

---

### **Use Cases for Retrospective Security**

1. **Identifying Previously Unknown Malware:**
    - Detect malware that was initially classified as benign but later deemed malicious.
2. **Tracking Malware Spread:**
    - Locate where the malware has been in the network over time.

---

### **Cisco Secure Endpoint and Retrospective Security**

- **File Disposition Changes:**
    - A file’s disposition (e.g., clean, malicious) can change if new intelligence warrants it.
    - Changes occur in real time on the cloud and the Cisco Secure Endpoint Console.
    - Enables immediate remediation for files that were previously misclassified.
- **Device Trajectory Feature:**
    - Tracks the movement and behavior of files within the network.
    - Enables retrospective security to monitor and remediate threats effectively.

---

## **Cloud-Based Indicators of Compromise (IOCs)**

### **Behavioral IOCs vs. Static Artifacts**

- **Static Artifacts:**
    - Focus on predefined file fingerprints or signatures to detect threats.
- **Behavioral IOCs:**
    - Detect events in real time based on the behavior of files rather than relying on signatures.
    - Useful for identifying malicious files that weren’t initially recognized as threats.

---

### **Examples of Behavioral IOC Detection**

- An unknown file is admitted into the network.
- The file copies itself to multiple machines.
- The file duplicates content from a hard drive.
- The file sends duplicate content to an unknown IP address.

---

### **Advantages of Behavioral IOCs**

- **Retrospection:**
    - Monitors systems for suspicious or unexplained activity over time.
- **Pattern Recognition:**
    - Identifies malware by recognizing behavioral patterns rather than relying on static signatures.
- **Environment-Wide Detection:**
    - Detects similar activities across the network, providing a broader view of potential threats.

---

### **Integration with Cisco Secure Endpoint**

- Behavioral IOCs are displayed in the **Device Trajectory** feature.
- Helps security practitioners visualize the movement and activities of files within the network.
- Provides actionable insights for remediation and future prevention.

---

### **Key Takeaways**

- Retrospective security enhances response capabilities by tracking past activities of files or traffic that were initially marked as safe.
- Behavioral IOCs enable real-time detection of malware based on its actions, not just its signature.
- Cisco Secure Endpoint’s **Device Trajectory** feature and cloud-based IOCs allow security teams to quickly identify, remediate, and prevent the spread of threats across the network.